import flet as ft


def main(page: ft.Page):
    page.title = "Пример навигации и маршрутизации"

    # Вызывается при КАЖДОМ изменении маршрута (вручную, кнопки браузера, page.go())
    def route_change(route: str):
        # Полностью пересобираем стек представлений
        page.views.clear()

        # Корневая страница "/"
        page.views.append(
            ft.View(
                route="/",
                controls=[
                    ft.AppBar(
                        title=ft.Text("Flet приложение – Главная"),
                        bgcolor="#eeeeee",  # чтобы не ловить ошибок с отсутствующими цветами
                    ),
                    ft.Text("Это главная страница", size=20),
                    ft.ElevatedButton(
                        "Посетить магазин",
                        on_click=lambda _: page.go("/store"),
                    ),
                ],
            )
        )

        # Если текущий маршрут /store – добавляем вторую страницу поверх
        if page.route == "/store":
            page.views.append(
                ft.View(
                    route="/store",
                    controls=[
                        ft.AppBar(
                            title=ft.Text("Магазин"),
                            bgcolor="#eeeeee",
                        ),
                        ft.Text("Это страница магазина", size=20),
                        ft.ElevatedButton(
                            "Вернуться на главную",
                            on_click=lambda _: page.go("/"),
                        ),
                    ],
                )
            )

        page.update()

    # Срабатывает, когда пользователь нажимает кнопку "Назад" в AppBar
    def view_pop(view: ft.View):
        # Удаляем верхнее представление
        page.views.pop()
        # Берём то, что под ним, и переходим к его маршруту
        top_view = page.views[-1]
        page.go(top_view.route)

    page.on_route_change = route_change
    page.on_view_pop = view_pop

    # Запускаем обработку текущего маршрута (обычно это "/")
    page.go(page.route)


if __name__ == "__main__":
    # Десктоп/мобильное окно:
    ft.app(target=main)
    # Если хочешь именно веб с адресной строкой, можно запускать так (НЕ ОБЯЗАТЕЛЬНО):
    # ft.app(target=main, view=ft.AppView.WEB_BROWSER, route_url_strategy="hash")
